/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.config.spec;

import com.momosoftworks.coldsweat.util.compat.CompatManager;
import com.momosoftworks.coldsweat.util.serialization.ListBuilder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class EntitySettingsConfig {
    private static final ForgeConfigSpec SPEC;
    private static final ForgeConfigSpec.Builder BUILDER;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> INSULATED_ENTITIES;
    public static final ForgeConfigSpec.ConfigValue<List<?>> GOAT_FUR_GROWTH_STATS;
    public static final ForgeConfigSpec.ConfigValue<List<?>> CHAMELEON_SHED_STATS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> CHAMELEON_SPAWN_BIOMES;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> GOAT_SPAWN_BIOMES;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> ENTITY_TEMPERATURES;
    private static final EntitySettingsConfig INSTANCE;

    public static void setup() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path csConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "coldsweat");
        try {
            Files.createDirectory(csConfigPath, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SPEC, "coldsweat/entity_settings.toml");
    }

    public static EntitySettingsConfig getInstance() {
        return INSTANCE;
    }

    public List<? extends List<?>> getInsulatedEntities() {
        return (List)INSULATED_ENTITIES.get();
    }

    public List<?> getGoatFurStats() {
        return (List)GOAT_FUR_GROWTH_STATS.get();
    }

    public List<?> getChameleonShedStats() {
        return (List)CHAMELEON_SHED_STATS.get();
    }

    public List<? extends List<?>> getChameleonSpawnBiomes() {
        return (List)CHAMELEON_SPAWN_BIOMES.get();
    }

    public List<? extends List<?>> getGoatSpawnBiomes() {
        return (List)GOAT_SPAWN_BIOMES.get();
    }

    public void setGoatFurStats(List<? extends Number> list) {
        GOAT_FUR_GROWTH_STATS.set(list);
    }

    public void setChameleonShedStats(List<? extends Number> list) {
        CHAMELEON_SHED_STATS.set(list);
    }

    static {
        BUILDER = new ForgeConfigSpec.Builder();
        INSTANCE = new EntitySettingsConfig();
        BUILDER.push("Entity Temperature");
        INSULATED_ENTITIES = BUILDER.comment(new String[]{"List of entities that will insulate the player when riding them", "A value of 0 provides no insulation; 1 provides full insulation", "Format: [[\"entity_id\", coldResistance, hotResistance], [\"entity_id\", coldResistance, hotResistance], etc...]"}).defineListAllowEmpty(List.of("Insulated Mounts"), () -> Arrays.asList(new List[0]), it -> {
            List list;
            return it instanceof List && (list = (List)it).size() == 3 && list.get(0) instanceof String && list.get(1) instanceof Number && list.get(2) instanceof Number;
        });
        ENTITY_TEMPERATURES = BUILDER.comment(new String[]{"Defines temperature-emitting properties for entities", "Format: [[\"entity_id\", temperature, range, *units], [\"entity_id\", temperature, range, *units], etc...]", "temperature: The temperature emitted by the entity", "range: The range of the effect, in blocks", "units: (Optional) The units of the temperature value (MC, F, or C). Defaults to MC"}).defineListAllowEmpty(List.of("Entity Temperatures"), () -> Arrays.asList(new List[0]), it -> {
            List list;
            return it instanceof List && (list = (List)it).size() >= 3 && list.get(0) instanceof String && list.get(1) instanceof Number && list.get(2) instanceof Number && (list.size() < 4 || list.get(3) instanceof String);
        });
        BUILDER.pop();
        BUILDER.push("Fur Growth & Shedding");
        GOAT_FUR_GROWTH_STATS = BUILDER.comment(new String[]{"Defines how often a goat will try to grow its fur, the growth cooldown after shearing, and the chance of it succeeding", "Format: [ticks, cooldown, chance]"}).defineList("Goat Fur Growth Timings", List.of(Integer.valueOf(1200), Integer.valueOf(2400), Double.valueOf(0.2)), it -> it instanceof Number);
        CHAMELEON_SHED_STATS = BUILDER.comment(new String[]{"Defines how often a chameleon will try to shed its skin, the cooldown after shedding, and the chance of it succeeding", "Format: [ticks, cooldown, chance]"}).defineList("Chameleon Shedding Timings", List.of(Integer.valueOf(100), Integer.valueOf(36000), Double.valueOf(0.1)), it -> it instanceof Number);
        BUILDER.pop();
        BUILDER.push("Mob Spawning");
        CHAMELEON_SPAWN_BIOMES = BUILDER.comment(new String[]{"Defines the biomes that Chameleons can spawn in", "Format: [[\"biome_id\", weight], [\"biome_id\", weight], etc...]"}).defineListAllowEmpty(List.of("Chameleon Spawn Biomes"), () -> ListBuilder.begin(new List[]{List.of("minecraft:bamboo_jungle", Integer.valueOf(80)), List.of("minecraft:jungle", Integer.valueOf(80)), List.of("minecraft:sparse_jungle", Integer.valueOf(35)), List.of("minecraft:desert", Integer.valueOf(1))}).addIf(CompatManager.isBiomesOPlentyLoaded(), () -> List.of("biomesoplenty:lush_desert", Integer.valueOf(3)), () -> List.of("biomesoplenty:rainforest", Integer.valueOf(20)), () -> List.of("biomesoplenty:rocky_rainforest", Integer.valueOf(15)), () -> List.of("biomesoplenty:fungal_jungle", Integer.valueOf(10)), () -> List.of("biomesoplenty:tropics", Integer.valueOf(8)), () -> List.of("biomesoplenty:outback", Integer.valueOf(2))).addIf(CompatManager.isBiomesYoullGoLoaded(), () -> List.of("byg:tropical_rainforest", Integer.valueOf(60)), () -> List.of("byg:jacaranda_forest", Integer.valueOf(3)), () -> List.of("byg:guiana_shield", Integer.valueOf(3)), () -> List.of("byg:crag_gardens", Integer.valueOf(4)), () -> List.of("byg:atacama_desert", Integer.valueOf(1)), () -> List.of("byg:cypress_swamplands", Integer.valueOf(3)), () -> List.of("byg:mojave_desert", Integer.valueOf(1)), () -> List.of("byg:windswept_desert", Integer.valueOf(2))).addIf(CompatManager.isAtmosphericLoaded(), () -> List.of("atmospheric:dunes", Double.valueOf(0.75)), () -> List.of("atmospheric:flourishing_dunes", Double.valueOf(1.5)), () -> List.of("atmospheric:rocky_dunes", Double.valueOf(0.75)), () -> List.of("atmospheric:petrified_dunes", Double.valueOf(0.5)), () -> List.of("atmospheric:rainforest", Integer.valueOf(50)), () -> List.of("atmospheric:sparse_rainforest", Integer.valueOf(40)), () -> List.of("atmospheric:rainforest_basin", Integer.valueOf(50)), () -> List.of("atmospheric:sparse_rainforest_basin", Integer.valueOf(30))).addIf(CompatManager.isTerralithLoaded(), () -> List.of("terralith:red_oasis", Integer.valueOf(3)), () -> List.of("terralith:desert_oasis", Integer.valueOf(3)), () -> List.of("terralith:tropical_jungle", Integer.valueOf(80)), () -> List.of("terralith:arid_highlands", Double.valueOf(1.5)), () -> List.of("terralith:rocky_jungle", Integer.valueOf(80)), () -> List.of("terralith:brushland", Double.valueOf(1.5))).addIf(CompatManager.isWythersLoaded(), () -> List.of("wythers:cactus_desert", Integer.valueOf(1)), () -> List.of("wythers:tropical_forest", Integer.valueOf(10)), () -> List.of("wythers:tropical_rainforest", Integer.valueOf(80))).build(), it -> {
            List list;
            return it instanceof List && (list = (List)it).size() == 2 && list.get(0) instanceof String && list.get(1) instanceof Number;
        });
        GOAT_SPAWN_BIOMES = BUILDER.comment(new String[]{"Defines additional biomes that goats can spawn in", "Format: [[\"biome_id\", weight], [\"biome_id\", weight], etc...]", "Not affected by the \"Increase Goat Spawns\" option"}).defineListAllowEmpty(List.of("Goat Spawn Biomes"), () -> ListBuilder.begin(new List[]{List.of("minecraft:frozen_peaks", Integer.valueOf(8)), List.of("minecraft:jagged_peaks", Integer.valueOf(8)), List.of("minecraft:snowy_slopes", Integer.valueOf(8)), List.of("minecraft:meadow", Integer.valueOf(3)), List.of("minecraft:windswept_hills", Integer.valueOf(6)), List.of("minecraft:windswept_forest", Integer.valueOf(6)), List.of("minecraft:windswept_gravelly_hills", Integer.valueOf(4)), List.of("minecraft:grove", Integer.valueOf(5)), List.of("minecraft:stony_peaks", Integer.valueOf(8))}).addIf(CompatManager.isBiomesOPlentyLoaded(), () -> List.of("biomesoplenty:boreal_forest", Integer.valueOf(5)), () -> List.of("biomesoplenty:jade_cliffs", Integer.valueOf(4)), () -> List.of("biomesoplenty:crag", Integer.valueOf(3))).addIf(CompatManager.isBiomesYoullGoLoaded(), () -> List.of("byg:canadian_shield", Integer.valueOf(3)), () -> List.of("byg:guiana_shield", Integer.valueOf(3)), () -> List.of("byg:fragment_forest", Integer.valueOf(128)), () -> List.of("byg:howling_peaks", Integer.valueOf(6)), () -> List.of("byg:shattered_glacier", Integer.valueOf(6)), () -> List.of("byg:dacite_ridges", Integer.valueOf(5))).addIf(CompatManager.isTerralithLoaded(), () -> List.of("terralith:blooming_plateau", Integer.valueOf(5)), () -> List.of("terralith:rocky_mountains", Integer.valueOf(6)), () -> List.of("terralith:alpine_grove", Integer.valueOf(6)), () -> List.of("terralith:scarlet_mountains", Integer.valueOf(4)), () -> List.of("terralith:windswept_spires", Integer.valueOf(16)), () -> List.of("terralith:cloud_forest", Integer.valueOf(4)), () -> List.of("terralith:haze_mountain", Integer.valueOf(4))).build(), it -> {
            List list;
            return it instanceof List && (list = (List)it).size() == 2 && list.get(0) instanceof String && list.get(1) instanceof Number;
        });
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

